/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.client.renderers.StructureBoundsRenderer;
import com.legacy.structure_gel.core.structure.StructureInfo;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SendStructureInfoToClientPacket {
    private final StructureInfo structureInfo;

    public SendStructureInfoToClientPacket(StructureInfo structureInfo) {
        this.structureInfo = structureInfo;
    }

    public static void encoder(SendStructureInfoToClientPacket packet, FriendlyByteBuf buff) {
        StructureInfo info = packet.structureInfo;
        if (info.dimension() != null) {
            buff.m_130085_(info.dimension());
            SendStructureInfoToClientPacket.writeBB(info.fullBounds(), buff);
            int count = info.pieces().size();
            buff.writeInt(count);
            for (int i = 0; i < count; ++i) {
                StructureInfo.PieceInfo pieceInfo = info.pieces().get(i);
                SendStructureInfoToClientPacket.writeBB(pieceInfo.bounds(), buff);
                buff.writeInt(pieceInfo.color());
            }
        }
    }

    private static void writeBB(BoundingBox bb, FriendlyByteBuf buff) {
        buff.writeInt(bb.m_162395_());
        buff.writeInt(bb.m_162396_());
        buff.writeInt(bb.m_162398_());
        buff.writeInt(bb.m_162399_());
        buff.writeInt(bb.m_162400_());
        buff.writeInt(bb.m_162401_());
    }

    public static SendStructureInfoToClientPacket decoder(FriendlyByteBuf buff) {
        ResourceLocation dimensionType = buff.m_130281_();
        BoundingBox fullBounds = SendStructureInfoToClientPacket.readBB(buff);
        int count = buff.readInt();
        ArrayList<StructureInfo.PieceInfo> pieces = new ArrayList<StructureInfo.PieceInfo>(count);
        for (int i = 0; i < count; ++i) {
            BoundingBox pieceBounds = SendStructureInfoToClientPacket.readBB(buff);
            int pieceColor = buff.readInt();
            pieces.add(new StructureInfo.PieceInfo(pieceBounds, pieceColor));
        }
        return new SendStructureInfoToClientPacket(new StructureInfo(dimensionType, fullBounds, pieces));
    }

    private static BoundingBox readBB(FriendlyByteBuf buff) {
        return new BoundingBox(buff.readInt(), buff.readInt(), buff.readInt(), buff.readInt(), buff.readInt(), buff.readInt());
    }

    public static void handler(SendStructureInfoToClientPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> StructureBoundsRenderer.addInfo(packet.structureInfo)));
        context.get().setPacketHandled(true);
    }
}

